function [ARcoefs, Estd]=getARmodel(trainingSigs,maxARorder)

[ntr,nt]=size(trainingSigs);

if nargin<2
    maxARorder=min([nt,100]);
end

% perform PCH to determine AR-model order
pcfbounds=zeros(ntr,1);
pcfs=zeros(ntr,maxARorder+1);
for trN=1:size(trainingSigs,1)
    Y=trainingSigs(trN,:);
    [pcf,~,pcfbound]=parcorr(Y,maxARorder);
    pcfbounds(trN)=pcfbound(1);
    pcfs(trN,:)=pcf;
end
mpcf=mean(pcfs,1);
mbounds=mean(pcfbounds);
ARorder=find(abs(mpcf)>mbounds,1,'last')-1;

% AR-model (this is where the magic happens)
[a,e] = arburg(trainingSigs',ARorder);
ARcoefs=mean(a,1);  % AR model coefficients
Estd=mean(e)^.5;    % noise varience