function [phase,amp,freq]=hilbertPhase(sig,bands,dt)

if nargin<3
    dt=1e-3;
end
if nargin<2
    bands=[40 100];
end

b1=bands(1);
b2=bands(2);

if isnan(b1); b1=[]; end;
if isnan(b2); b2=[]; end;

sig=sig(:)';

filtSig=eegfilt(sig,dt^-1,b1,b2);

hil=hilbert(filtSig);

phase=angle(hil);

if nargout>1
    T=round(1/(mean(bands)*dt));
    amp=abs(hil);
    amp=smooth(amp,1.5*T);
end

if nargout>2
    ph=smooth(unwrap(phase),1.5*T);
    freq=diff(ph)/(2*pi*dt);
    freq=interp1(1.5:1:length(ph),freq,1:length(ph));
end