function [pha,predSig]=realtimePhase(sigSnip,ARcoefs,getPhaseMethod,Estd,predSz)

sigSz=length(sigSnip);
ARorder=length(ARcoefs);

if sigSz<ARorder
    error(['signal snip must be at least ',num2str(ARorder),' long']);
end


if nargin<5
    predSz=sigSz;   % default: predict same size as original signal
end

if nargin<4
    Estd=0;         % default: don't drive AR with any error
end
if isempty(Estd)
    Estd=0;
end

if nargin<3         % default: use hilbertPhase function to get phase of signal
    getPhaseMethod=@hilbertPhase;
end
if isempty(getPhaseMethod)
    getPhaseMethod=@hilbertPhase;
end

M=sigSz;
P=sigSz+predSz;

Y=sigSnip;
[~, zf] = filter(-[0 ARcoefs(2:end)], 1, Y(1:M));     % get model state at the end of available signal
pred = filter(1, ARcoefs, Estd*randn(1,P-M), zf);     % predict
predSig = [Y(1:M) pred];

phas=getPhaseMethod(predSig);
pha=phas(sigSz);